unit ucReviews;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI,System.text, SysUtils,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, SmartDataGrid;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucReviews = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure DropDownListCategories_SelectedIndexChanged(sender: System.Object; 
      e: System.EventArgs);
    procedure DropDownListProducts_SelectedIndexChanged(sender: System.Object; 
      e: System.EventArgs);
    procedure DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dlSubMenu: System.Web.UI.WebControls.DataList;
    LabelCategory: System.Web.UI.WebControls.Label;
    DropDownListCategories: System.Web.UI.WebControls.DropDownList;
    LabelProduct: System.Web.UI.WebControls.Label;
    DropDownListProducts: System.Web.UI.WebControls.DropDownList;
    DG: SmartDataGrid.TSmartDataGrid;
    ErrorMessage: System.Web.UI.WebControls.Label;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure FillCategories;
    procedure FillProducts(const CatID : integer);
    procedure DoBindData;
  public
    { Public Declarations }
  end;

implementation

uses HelperDB;

procedure TucReviews.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  if not Page.IsPostBack then
  begin
    FillCategories();
    DropDownListProducts.Visible := false;
    LabelProduct.Visible := false;
  end
  else
  begin
    DropDownListProducts.Visible := true;
    LabelProduct.Visible := true;
    if Assigned(ViewState['PID']) then DoBindData;
  end;

end;

procedure TucReviews.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TucReviews.DropDownListCategories_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
begin
  FillProducts(Convert.ToInt32(DropDownListCategories.SelectedValue));
  try
    DropDownListProducts_SelectedIndexChanged(Sender, nil);
  except
  end;
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucReviews.InitializeComponent;
begin
  Include(Self.DropDownListCategories.SelectedIndexChanged, Self.DropDownListCategories_SelectedIndexChanged);
  Include(Self.DropDownListProducts.SelectedIndexChanged, Self.DropDownListProducts_SelectedIndexChanged);
  Include(Self.DG.UpdateCommand, Self.DG_UpdateCommand);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucReviews.FillCategories;
var
  ctext : string;
	cvalue : string;
  ds : DataSet;
begin
  ds := THelperDB.FillDataset('SELECT * FROM Categories');
  DropDownListCategories.DataSource :=  ds;

  ctext := ds.Tables[0].Columns[1].ToString();
  cvalue := ds.Tables[0].Columns[0].ToString();

  DropDownListCategories.DataTextField := ctext;
  DropDownListCategories.DataValueField := cvalue;
  DropDownListCategories.DataBind();
  DropDownListCategories.Items.Insert(0, ListItem.Create('-- Select category --','-1'));
  DropDownListCategories.SelectedIndex := 0;

end;

procedure TucReviews.FillProducts(const CatID: integer);
var
  prodSelSQL : StringBuilder;
  ds : DataSet;
begin
  if (DropDownListCategories.SelectedIndex <> 0) and (CatID > 0) then
  begin
    prodSelSQL := StringBuilder.Create;
    prodSelSQL.Append('SELECT Products.ProductID, Products.ModelName AS Expr1 ');
    prodSelSQL.Append('FROM  Products INNER JOIN Categories ');
    prodSelSQL.Append('ON Products.CategoryID = Categories.CategoryID ');
    prodSelSQL.Append('WHERE (Categories.CategoryID = ' + CatID.ToString + ') ');
    prodSelSQL.Append('ORDER BY Products.ModelName');

    ds := THelperDB.FillDataset(prodSelSQL.ToString);

    DropDownListProducts.DataSource := ds;
    DropDownListProducts.DataTextField := ds.Tables[0].Columns[1].ToString();
    DropDownListProducts.DataValueField := ds.Tables[0].Columns[0].ToString();
    DropDownListProducts.DataBind();
    DropDownListProducts.Items.Insert(0, ListItem.Create('-- Select product --','-1'));
    DropDownListProducts.SelectedIndex := 0;
  end
  else
  begin
    DropDownListProducts.SelectedIndex:=0;
    DropDownListProducts.Visible := false;
    LabelProduct.Visible := false;
    DG.Visible := false;
    ErrorMessage.Text := 'Bad data, please select a category from the list!';
  end;
end;

procedure TucReviews.DoBindData;
var
  SelSQL : StringBuilder;
begin

  SelSQL := StringBuilder.Create;
  SelSQL.Append('SELECT Products.ProductID, Reviews.* FROM Products ');
  SelSQL.Append('INNER JOIN Reviews ');
  SelSQL.Append('ON Products.ProductID = Reviews.ProductID ');
  SelSQL.Append('WHERE (Products.ProductID = ' + ViewState['PID'].ToString + ')');
  SelSQL.Append('ORDER BY Reviews.ReviewID DESC');


  DG.SelectSQL := SelSQL.ToString;

  dg.DeleteSQL := 'DELETE FROM Reviews WHERE ReviewID = ';
  DG.AutoGenerateColumns:=False;
  DG.PageSize:=15;
  DG.AllowPaging := True;
  DG.ErrorLabel := ErrorMessage;
  DG.DataKeyField := 'ReviewID';

  DG.BindData;

end;

procedure TucReviews.DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  ReviewID, Comments: string;
begin
  ReviewID := DG.DataKeys[e.Item.ItemIndex].ToString();
  Comments := TextBox(e.Item.FindControl('Comments')).Text;

  DG.UpdateSQL := 'UPDATE Reviews SET Comments = ' + QuotedStr(Server.HtmlEncode(Comments)) +' Where ReviewID = ' + ReviewID;
end;

procedure TucReviews.DropDownListProducts_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
var
  pID : string;
begin
  pID := DropDownListProducts.SelectedValue.ToString();

  if Convert.ToInt32(pID) > 0 then
  begin
    DG.Visible := true;
    ErrorMessage.Text := '';

    ViewState['PID'] := pid;
  end
  else
  begin
    DG.Visible := false;
    ErrorMessage.Text := 'Bad data, please select a product from the list!';
  end;
  DoBindData;


end;

end.
